
const { PrismaClient } = require('@prisma/client');
const bcrypt = require('bcryptjs');

const prisma = new PrismaClient();

async function createAdmin() {
  const username = 'admin';
  const password = 'admin123';
  const hashedPassword = await bcrypt.hash(password, 10);

  console.log(`Creating/Updating admin user: ${username}`);

  try {
    const user = await prisma.user.upsert({
      where: { username },
      update: {
        password: hashedPassword,
        role: 'ADMIN'
      },
      create: {
        username,
        password: hashedPassword,
        role: 'ADMIN',
        email: 'admin@mydracin.com'
      }
    });
    console.log('Admin user created/updated successfully:', user.id);
  } catch (error) {
    console.error('Error creating admin user:', error);
  } finally {
    await prisma.$disconnect();
  }
}

createAdmin();
